' Copyright (C) 1997-2001 Agilent Technologies
' VXIplug&play Instrument Driver for the E1459

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

'  Returned error status values
'  Agilent Common Error numbers start at BFFC0D00

Global Const hpe1459_INSTR_ERROR_NOT_VXI                      = &HBFFC0D00&
' D01 unused
Global Const hpe1459_INSTR_ERROR_NULL_PTR                     = &HBFFC0D02&
Global Const hpe1459_INSTR_ERROR_RESET_FAILED                 = &HBFFC0D03&
Global Const hpe1459_INSTR_ERROR_UNEXPECTED                   = &HBFFC0D04&
Global Const hpe1459_INSTR_ERROR_INV_SESSION                  = &HBFFC0D05&
Global Const hpe1459_INSTR_ERROR_LOOKUP                       = &HBFFC0D06&
Global Const hpe1459_INSTR_ERROR_DETECTED                     = &HBFFC0D07&

' Parameter errors not in VPP 3.4
Global Const hpe1459_INSTR_ERROR_PARAMETER9                   = &HBFFC0D20&
Global Const hpe1459_INSTR_ERROR_PARAMETER10                  = &HBFFC0D21&
Global Const hpe1459_INSTR_ERROR_PARAMETER11                  = &HBFFC0D22&
Global Const hpe1459_INSTR_ERROR_PARAMETER12                  = &HBFFC0D23&
Global Const hpe1459_INSTR_ERROR_PARAMETER13                  = &HBFFC0D24&
Global Const hpe1459_INSTR_ERROR_PARAMETER14                  = &HBFFC0D25&
Global Const hpe1459_INSTR_ERROR_PARAMETER15                  = &HBFFC0D26&
Global Const hpe1459_INSTR_ERROR_PARAMETER16                  = &HBFFC0D27&
Global Const hpe1459_INSTR_ERROR_PARAMETER17                  = &HBFFC0D28&
Global Const hpe1459_INSTR_ERROR_PARAMETER18                  = &HBFFC0D29&

'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

' required plug and play functions from VPP-3.1
Declare Function hpe1459_init Lib "hpe1459_32.dll" (ByVal InstrDesc As String, ByVal id_query As Integer, ByVal do_reset As Integer, vi As Long) As Long

Declare Function hpe1459_close Lib "hpe1459_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1459_reset Lib "hpe1459_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1459_self_test Lib "hpe1459_32.dll" (ByVal vi As Long, test_result As Integer, ByVal test_message As String) As Long

Declare Function hpe1459_error_query Lib "hpe1459_32.dll" (ByVal vi As Long, error_number As Long, ByVal error_message As String) As Long

Declare Function hpe1459_error_message Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal error_number As Long, ByVal message As String) As Long

Declare Function hpe1459_revision_query Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal driver_rev As String, ByVal instr_rev As String) As Long

Declare Function hpe1459_timeOut Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal tmo As Long) As Long

Declare Function hpe1459_timeOut_Q Lib "hpe1459_32.dll" (ByVal vi As Long, tmo As Long) As Long

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

' Used by Function hpe1459_enablePort
Global Const hpe1459_PORT_0                               = 0
Global Const hpe1459_PORT_1                               = 1
Global Const hpe1459_PORT_2                               = 2
Global Const hpe1459_PORT_3                               = 3
Global Const hpe1459_ENABLE_DAV                           = 4
Global Const hpe1459_ENABLE_EDGE                          = 1

' Used by Function hpe1459_getAttribute
Global Const hpe1459_ATTRIB_LOCK_TMO                      = 0
Global Const hpe1459_ATTRIB_TRACE_DEST                    = 1
Global Const hpe1459_ATTRIB_TRACE_LEVEL                   = 2
Global Const hpe1459_ATTRIB_EVENT_ERROR_UH                = 3

' Used by Function hpe1459_input
'    hpe1459_PORT_0
'    hpe1459_PORT_1
'    hpe1459_PORT_2
'    hpe1459_PORT_3
Global Const hpe1459_UNUSED                               = 0
Global Const hpe1459_CLOCK_INT                            = 1
Global Const hpe1459_CLOCK_EXT                            = 2
Global Const hpe1459_DEBOUNCE_MAX                         = 9600
Global Const hpe1459_DEBOUNCE_MIN                         = 0

' Used by Function hpe1459_input_Q
'    hpe1459_PORT_0
'    hpe1459_PORT_1
'    hpe1459_PORT_2
'    hpe1459_PORT_3

' Used by Function hpe1459_measDigData_Q
Global Const hpe1459_CHANNEL_MAX                          = 63
Global Const hpe1459_CHANNEL_MIN                          = 0

' Used by Function hpe1459_measDigPort_Q
'    hpe1459_PORT_0
'    hpe1459_PORT_1
'    hpe1459_PORT_2
'    hpe1459_PORT_3

' Used by Function hpe1459_negMask
'    hpe1459_PORT_0
'    hpe1459_PORT_1
'    hpe1459_PORT_2
'    hpe1459_PORT_3
Global Const hpe1459_MASK_MAX                             = 32767
Global Const hpe1459_MASK_MIN                             = -32768

' Used by Function hpe1459_negMask_Q
'    hpe1459_PORT_0
'    hpe1459_PORT_1
'    hpe1459_PORT_2
'    hpe1459_PORT_3

' Used by Function hpe1459_posMask
'    hpe1459_PORT_0
'    hpe1459_PORT_1
'    hpe1459_PORT_2
'    hpe1459_PORT_3
'    hpe1459_MASK_MAX
'    hpe1459_MASK_MIN

' Used by Function hpe1459_posMask_Q
'    hpe1459_PORT_0
'    hpe1459_PORT_1
'    hpe1459_PORT_2
'    hpe1459_PORT_3

' Used by Function hpe1459_sensEvenNedg_Q
'    hpe1459_CHANNEL_MAX
'    hpe1459_CHANNEL_MIN

' Used by Function hpe1459_sensEvenPedg_Q
'    hpe1459_CHANNEL_MAX
'    hpe1459_CHANNEL_MIN

' Used by Function hpe1459_sensNegPortTran_Q
'    hpe1459_PORT_0
'    hpe1459_PORT_1
'    hpe1459_PORT_2
'    hpe1459_PORT_3

' Used by Function hpe1459_sensPosPortTran_Q
'    hpe1459_PORT_0
'    hpe1459_PORT_1
'    hpe1459_PORT_2
'    hpe1459_PORT_3

' Used by Function hpe1459_sensRegState_Q
'    hpe1459_PORT_0
'    hpe1459_PORT_1
'    hpe1459_PORT_2
'    hpe1459_PORT_3

' Used by Function hpe1459_setAttribute
'    hpe1459_ATTRIB_LOCK_TMO
'    hpe1459_ATTRIB_TRACE_DEST
'    hpe1459_ATTRIB_TRACE_LEVEL
'    hpe1459_ATTRIB_EVENT_ERROR_UH
Global Const hpe1459_ATTRIB_CLEAR_CMD                     = 4
Global Const hpe1459_SA_MAX                               = 2147483647&
Global Const hpe1459_SA_MIN                               = 0


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

Declare Function hpe1459_clearAllEvents Lib "hpe1459_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1459_enablePort Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal port As Long, ByVal data As Long) As Long

Declare Function hpe1459_getAttribute Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal attrib As Long, data As Long) As Long

Declare Function hpe1459_input Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal port As Long, ByVal clock_src As Long, ByVal deb_time As Double) As Long

Declare Function hpe1459_input_Q Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal port As Long, clock_src As Integer, deb_time As Double) As Long

Declare Function hpe1459_measAllDigData_Q Lib "hpe1459_32.dll" (ByVal vi As Long, port3 As Integer, port2 As Integer, port1 As Integer, port0 As Integer) As Long

Declare Function hpe1459_measAllNegTran_Q Lib "hpe1459_32.dll" (ByVal vi As Long, port3 As Integer, port2 As Integer, port1 As Integer, port0 As Integer) As Long

Declare Function hpe1459_measAllPosTran_Q Lib "hpe1459_32.dll" (ByVal vi As Long, port3 As Integer, port2 As Integer, port1 As Integer, port0 As Integer) As Long

Declare Function hpe1459_measDigData_Q Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal channel As Long, data As Integer) As Long

Declare Function hpe1459_measDigPort_Q Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal port As Long, data As Integer) As Long

Declare Function hpe1459_negMask Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal port As Long, ByVal data As Integer) As Long

Declare Function hpe1459_negMask_Q Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal port As Long, data As Integer) As Long

Declare Function hpe1459_posMask Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal port As Long, ByVal data As Integer) As Long

Declare Function hpe1459_posMask_Q Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal port As Long, data As Integer) As Long

Declare Function hpe1459_sensEvenNedg_Q Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal channel As Long, data As Integer) As Long

Declare Function hpe1459_sensEvenPedg_Q Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal channel As Long, data As Integer) As Long

Declare Function hpe1459_sensNegPortTran_Q Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal port As Long, data As Integer) As Long

Declare Function hpe1459_sensPosPortTran_Q Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal port As Long, data As Integer) As Long

Declare Function hpe1459_sensRegState_Q Lib "hpe1459_32.dll" (ByVal vi As Long, StatusReg As Integer, EdgeReg As Integer, DAVReg As Integer, ByVal port As Long, CmdReg As Integer) As Long

Declare Function hpe1459_setAttribute Lib "hpe1459_32.dll" (ByVal vi As Long, ByVal attrib As Long, ByVal data As Long) As Long

